
(* 2x1 flyways 1 xbot (actual physical) with border 1 on the bottom edge of the 2 flyways - GetBorderStatus, ReadNumIncomingXbots, GetIncomingXbots *)
FUNCTION_BLOCK Example30_incoming
	(*2x1 flyways 1 xbot (actual physical) with border 1 on the bottom edge of the 2 flyways - GetBorderStatus, ReadNumIncomingXbots, GetIncomingXbots*)
	(*additional user controlled PMC with 2x1 flyways with border 1 on the top edge, xbot starts on the user controlled PMC*)

	(*reset new xbot flag*)
	IF(NOT(Execute))THEN
		processing_new_xbot := FALSE;
	END_IF;

	(*verify status of the boundary *)
	PMC_GetBorderStatus1(PM_Controller := PM_Controller,Execute := Execute,BorderID := 1);

	(*wait until an xbot shows up on the boundary (user needs to manually move xbot over boundary using the other PMC)*)
	PMC_ReadNumIncomingXbots1(PM_Controller := PM_Controller,Enable := PMC_GetBorderStatus1.Done AND PMC_GetBorderStatus1.State = 2);
	num_incoming := PMC_ReadNumIncomingXbots1.nXbots;
	IF(num_incoming > 0 AND NOT(processing_new_xbot))THEN
		processing_new_xbot := TRUE;
	END_IF;

	(*get ID of the incoming xbot*)
	PMC_GetIncomingXbots1(PM_Controller := PM_Controller,Execute := processing_new_xbot);
	nXbots := PMC_GetIncomingXbots1.nXbots;
	XbotIDS := PMC_GetIncomingXbots1.XbotIDs;
	BorderIDs := PMC_GetIncomingXbots1.BorderIDs;

	(*move xbot around the PLC controlled flyways*)
	PMC_XYMotion1(PM_Controller := PM_Controller,Execute := PMC_GetIncomingXbots1.Done,XbotID := XbotIDS[0],PosX := 0.06,PosY := 0.18);
	PMC_XYMotion2(PM_Controller := PM_Controller,Execute := PMC_XYMotion1.Done,XbotID := XbotIDS[0],PosX := 0.42,PosY := 0.18);

	(*move xbot back over the boundary*)
	PMC_XYMotion3(PM_Controller := PM_Controller,Execute := PMC_XYMotion2.Done,XbotID := XbotIDS[0],PosX := 0.36,PosY := -0.12);

	Done := PMC_XYMotion3.Done;
	IF(Done)THEN
		processing_new_xbot := FALSE;
	END_IF;
END_FUNCTION_BLOCK
